// AddrTabCtrl.cpp : implementation file
//

#include "stdafx.h"
#include "Addr.h"
#include "AddrTabCtrl.h"
#include "ParseDlg.h"
#include "AddrDlg.h"
#include "StreetDlg.h"
#include "ZipDlg.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAddrTabCtrl

CAddrTabCtrl::CAddrTabCtrl()
{
	m_DialogID[0] =IDD_ADDR_DIALOG;
	m_DialogID[1] =IDD_PARSE_DIALOG;
	m_DialogID[2] =IDD_STREET_DIALOG;
	m_DialogID[3] =IDD_ZIP_DIALOG;


   m_Dialog[0] = new CAddrDlg();
   m_Dialog[1] = new CParseDlg();
   m_Dialog[2] = new CStreetDlg();
   m_Dialog[3] = new CZipDlg();

   m_nPageCount = 4;
}

CAddrTabCtrl::~CAddrTabCtrl()
{
}
 void CAddrTabCtrl::InitDialogs()
{
	m_Dialog[0]->Create(m_DialogID[0],GetParent());
	m_Dialog[1]->Create(m_DialogID[1],GetParent());
	m_Dialog[2]->Create(m_DialogID[2],GetParent());
	m_Dialog[3]->Create(m_DialogID[3],GetParent());
}

BEGIN_MESSAGE_MAP(CAddrTabCtrl, CTabCtrl)
	//{{AFX_MSG_MAP(CAddrTabCtrl)
	//ON_NOTIFY(TCN_SELCHANGE, IDC_ADDRMAINTAB, OnSelchange)
	ON_NOTIFY_REFLECT(TCN_SELCHANGE, OnSelchange) 
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAddrTabCtrl message handlers

void CAddrTabCtrl::OnSelchange(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	   // TODO: Add your control notification handler code here
   ActivateTabDialogs();

	*pResult = 0;
}
 void CAddrTabCtrl::ActivateTabDialogs()
{
  int nSel = GetCurSel();
  if(m_Dialog[nSel]->m_hWnd)
     m_Dialog[nSel]->ShowWindow(SW_HIDE);

  CRect l_rectClient;
  CRect l_rectWnd;

  GetClientRect(l_rectClient);
  AdjustRect(FALSE,l_rectClient);
  GetWindowRect(l_rectWnd);
  GetParent()->ScreenToClient(l_rectWnd);
  l_rectClient.OffsetRect(l_rectWnd.left,l_rectWnd.top);
  for(int nCount=0; nCount < m_nPageCount; nCount++){
     m_Dialog[nCount]->SetWindowPos(&wndTop, l_rectClient.left, l_rectClient.top, l_rectClient.Width(), l_rectClient.Height(), SWP_HIDEWINDOW);
  }
  m_Dialog[nSel]->SetWindowPos(&wndTop, l_rectClient.left, l_rectClient.top, l_rectClient.Width(), l_rectClient.Height(), SWP_SHOWWINDOW);

  m_Dialog[nSel]->ShowWindow(SW_SHOW);

}
